/* SPI IoT Ethernet Linux driver */

 /* 
 * Copyright (c) 2016 MSTAR Corporation
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 */
 
#include <linux/kernel.h>
#include "iot_api.h"

#include "iot_bus.h"

static struct iot_dev_ops *pIoT_dev_ops = 0;

static int iot_write_eth_data (void *data, int len)
{
	if(pIoT_dev_ops)
		return pIoT_dev_ops->eth_tx(SPIS_CMD_ETH_PKT_TX, data, len);
	else 
		return -1;
}

static int iot_read_data (u16 type, void *data, int len)
{
	if(pIoT_dev_ops)
		return pIoT_dev_ops->read( type,  data, len);
	else
		return -1;
}
#if 0
static int iot_write_data (u32 data_type, void *data, int len)
{
	return pIoT_dev_ops->write(data_type, data, len);
}
#endif

int iot_get_mac(int eth_if, char *addr )
{
	return pIoT_dev_ops->get_mac(eth_if, addr);
}


int iot_get_linkstatus(u32 *link )
{
	return iot_read_data(SPIS_CMD_GET_LINK, link, (u32)sizeof(u32));
}


int iot_get_info(int eth_if, iot_dev_info_t *info )
{
#if 0
	if(eth_if)
		return iot_read_data( SPIS_CMD_GET_INFO_ETH1, info, (u32)sizeof(iot_dev_info_t));
	else
		return iot_read_data( SPIS_CMD_GET_INFO, info, (u32)sizeof(iot_dev_info_t));
#endif
	pIoT_dev_ops->get_wifi_config(info);
	return 0;
}

int iot_set_wifi( iot_wifi_setting_t *wifisetting)
{
	return pIoT_dev_ops->set_wifi_config(wifisetting);
}

int iot_set_power(u32 mode )
{
	printk(KERN_INFO "iot_set_power %d.\n",mode);	
	return  pIoT_dev_ops->sleep();
}


struct sk_buff *
iot_fill_skb_header(struct net_device *ndev, struct sk_buff_head *q)
{
	return pIoT_dev_ops->fill_skb_header(ndev, q);
}


int iot_packet_send( struct sk_buff *tx_skb )
{
	int ret;

	while((ret = iot_write_eth_data( tx_skb->data, tx_skb->len)))
	{

		if(ret==0)
			break;
		
		if(ret==-ETIME)
		{
			pr_err("iot_packet_send timeout %d\n",ret);
		
			continue;
		}		
		else
		{
			pr_err("mt7687_hard_xmit error %d\n",ret);
			
			break;
		}
	}
	return ret;
}

int iot_packet_send_2_pkt( struct sk_buff *tx_skb1, struct sk_buff *tx_skb2 )
{
	int ret;

	while((ret = pIoT_dev_ops->eth_tx_2_pkt(0, tx_skb1->data, tx_skb1->len, tx_skb2->data, tx_skb2->len)))
	{

		if(ret==0)
			break;
		
		if(ret==-ETIME)
		{
			pr_err("iot_packet_send timeout %d\n",ret);
		
			continue;
		}		
		else
		{
			pr_err("mt7687_hard_xmit error %d\n",ret);
			
			break;
		}
	}
	return 0;
}


int iot_read_eth_packet( void *data, int len)
{
	return iot_read_data(SPIS_CMD_GET_ETH_PKT, data, len);
}

int  iot_init(void* priv_data)
{
	int ret = -1;
	
	if(pIoT_dev_ops)
		ret = pIoT_dev_ops->init(priv_data);
	else
		pr_err("IoT device driver ops not register.");
	return ret;
}

int  iot_close(void* priv_data)
{
	int ret = -1;
	
	if(pIoT_dev_ops)
		ret = pIoT_dev_ops->close(priv_data);
	else
		pr_err("IoT device driver ops not register.");

	return ret;
}

int register_iot_ops(struct iot_dev_ops* ops)
{
	pIoT_dev_ops = ops;
	return 0;
}

